package cn.gtmap.gtc.storage.domain.enums;

import org.springframework.util.StringUtils;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/27
 * @description
 */
public enum ShareTimeEnum {
    DAY ("1天", "DAY"),
    WEEK ("1周", "WEEK"),
    MONTH ("1月", "MONTH"),
    FOREVER ("永久有效", "FOREVER");

    private String desc;
    private String time;

    ShareTimeEnum(String desc, String time) {
        this.desc = desc;
        this.time = time;
    }

    public static ShareTimeEnum enumValue(String time){
        if (StringUtils.isEmpty(time)) {
            return FOREVER;
        }
        for (ShareTimeEnum temp : ShareTimeEnum.values()) {
            if (temp.time.equals(time)) {
                return temp;
            }
        }
        return FOREVER;
    }

    public String getDesc() {
        return desc;
    }

    public String getTime() {
        return time;
    }
}
