package cn.gtmap.gtc.storage.domain.enums;

import org.springframework.util.StringUtils;

/**
 * @author zenglihuan
 * @create 2018/11/15 15:07
 * @discription 文件权限，查看、编辑
 **/
public enum ShareAuthorityEnum
{
    VIEW("VIEW"),
    EDIT("EDIT");

    String value;

    ShareAuthorityEnum(String value) {
        this.value = value;
    }

    public static ShareAuthorityEnum enumOfValue(String value){
        if(StringUtils.isEmpty(value)){
            return ShareAuthorityEnum.VIEW;
        }
        switch (value){
            case "VIEW": return ShareAuthorityEnum.VIEW;
            case "EDIT": return ShareAuthorityEnum.EDIT;
            default: return ShareAuthorityEnum.VIEW;
        }
    }

    public String value(){
        return this.value;
    }

}