package cn.gtmap.gtc.storage.domain.enums;

/**
 * @author zenglihuan
 * @create 2018/11/5 13:50
 * @discription 回调状态
 **/
public enum CallbackStatusEnum {

    NOT_FOUND(0),
    BEING_EDITED(1),
    READY_SAVING(2),
    SAVING_ERROR(3),
    NO_CHANGES(4),
    SAVED(6),
    FORCE_SAVING_ERROR(7);

    int value;

    CallbackStatusEnum(int value) {
        this.value = value;
    }

    public static CallbackStatusEnum enumOfValue(int value){
        switch (value){
            case 0: return CallbackStatusEnum.NOT_FOUND;
            case 1: return CallbackStatusEnum.BEING_EDITED;
            case 2: return CallbackStatusEnum.READY_SAVING;
            case 3: return CallbackStatusEnum.SAVING_ERROR;
            case 4: return CallbackStatusEnum.NO_CHANGES;
            case 6: return CallbackStatusEnum.SAVED;
            case 7: return CallbackStatusEnum.FORCE_SAVING_ERROR;
            default: return null;
        }
    }

    public int value(){
        return this.value;
    }

}
