package cn.gtmap.gtc.storage.clients.v1;

import cn.gtmap.gtc.storage.domain.dto.HistoryDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zenglihuan
 * @create 2018/11/6 16:36
 * @discription 文档历史版本
 **/
@FeignClient(name = "${app.services.storage-app:storage-app}")
@RequestMapping("/storage/rest/v1/histories")
public interface HistoryClient {

    @GetMapping
    public List<HistoryDto> findHistoriesByStorage(@RequestParam(name = "storageId") String storageId, @RequestParam(name = "recent") int recent);

    @GetMapping("/{id}")
    public HistoryDto findById(@PathVariable(name = "id") String id);

}
