package cn.gtmap.gtc.storage.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/19
 * @description
 */

@Setter
@Getter
public class StorageDto implements Serializable {

    private String id;

    /*
     *  应用ID
     * */
    private String clientId;

    /*
     *  存储空间编码
     * */
    private String spaceId;

    /*
     * 删除状态0 :删除， 1 正常
     * */
    private int enabled;

    /*
     * 文件类型 0：目录 2: 图片 3： 文档 4： 视频 5：音乐，6：其他
     * */
    private int type;

    /*
     * 文件名称
     * */
    private String name;

    /*
     * 文件文件拥有者
     * */
    private String owner;

    /*
     * 文件存储路径
     * */
    private String path;

    /*
     * 文件下载路径
     * */
    private String downUrl;

    /*
     * 文件层级 >= 0
     * */
    private int weight;

    /*
     *  文件当前键值， onlyOffice 使用
     * */
    private String currentKey;

    /*
     *  文件更新者， onlyOffice 使用， 用户Id
     * */
    private String updatedBy;

    /*
     *  文件更新者， onlyOffice 使用， 用户Id
     * */
    private long currentVersion;

    /*
     *  文件长度
     * */
    private long fileSize;

    /*
     *  文件媒体类型  如：image/png
     * */
    private String fileType;

    /*
     *  本地存储:local   阿里方式：oss   Hbase方式：hbase
     * */
    private String storeType;

//    /*
//    * 下载次数
//    * */
//    private Long downCount = 0L;
//
//    /*
//    *  查看次数
//    * */
//    private Long readCount = 0L;

    /*
     *  文件上一级信息，主要键值Id
     * */
    private StorageDto parent;

    private List<StorageDto> children;

    // 文件数量
    private Long fileCount;

    /*
     *  文件共享信息
     * */
    private ShareDto share;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;


    //创建时间戳
    private Long createTime;

    //文件权限标签
    private String fileAuthorities;

    
}
