package cn.gtmap.gtc.storage.domain.enums;

/**
 * @version 1.0 2020-7-1
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public enum VideoTransEnum {

    /*
     * 任务状态 0：未开始 1：已开始 2：已完成 9:失败
     * */
    NOSTART(0),
    STARTED(1),
    FINISHED(2),
    FAILURE(9);

    int status;

    VideoTransEnum(int status) {
        this.status = status;
    }

    public int intValue() {
        return this.status;
    }

    public static VideoTransEnum enumValue(Integer type) {
        if (null == type) {
            return null;
        }
        switch (type) {
            case 0:
                return NOSTART;
            case 1:
                return STARTED;
            case 2:
                return FINISHED;
            case 9:
                return FAILURE;
        }
        return NOSTART;
    }

}
