package cn.gtmap.gtc.storage.domain.enums;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/25
 * @description
 */
public enum FileTypeEnum {
    /*
     * 文件类型 0：目录 1：文件，2: 图片 3： 文档 4： 视频 5：音乐，6：其他
     * */
    FOLDER(0),
    FILE(1),
    PICTURE(2),
    DOC(3),
    VIDEO(4),
    MUSIC(5),
    OTHER(6);

    int type;

    FileTypeEnum(int type) {
        this.type = type;
    }

    public int intValue(){
        return  this.type;
    }

    public static FileTypeEnum enumValue(Integer type){
        if (null == type){
            return null;
        }
        switch (type){
            case 0:
                return FOLDER;
            case 1:
                return FILE;
            case 2:
                return PICTURE;
            case 3:
                return DOC;
            case 4:
                return VIDEO;
            case 5:
                return MUSIC;
            case 6:
                return OTHER;
        }
        return FILE;
    }
}
