package cn.gtmap.gtc.storage.clients.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.storage.domain.dto.ShareDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/27
 * @description
 */

@FeignClient(name = "${app.services.storage-app:storage-app}")
@RequestMapping("/storage/rest/v1/shares")
public interface ShareClient {

    /**
     * @param owner 拥有者 name: 文件名称
     * @return
     * @description 网盘模式-根据文档拥有者分页分享文件
     */
    @GetMapping("/owner")
    PageResult<ShareDto> listOwnerShares(Pageable pageable,
                                         @RequestParam(name = "clientId", required = false) String clientId,
                                         @RequestParam(name = "spaceId", required = false) String spaceId,
                                         @RequestParam(name = "owner", required = false) String owner,
                                         @RequestParam(name = "name", required = false) String name);

    /**
     * @param pageable
     * @param name 文件名称
     * @return
     * @description 网盘模式-管理员查看所有根节点文件
     */
    @GetMapping("/admin")
    PageResult<ShareDto> listAdminShares(Pageable pageable,
                                         @RequestParam(name = "clientId", required = false) String clientId,
                                         @RequestParam(name = "spaceId", required = false) String spaceId,
                                         @RequestParam(name = "name", required = false) String name);

    /**
     * @param pageable 分页参数
     * @param spaceId 文件名称
     * @param owner 拥有者
     * @param name 文件名
     * @return
     * @description 项目模式-查看用户空间下的共享文件
     */
    @GetMapping("/project")
    PageResult<ShareDto> listProjectShares(Pageable pageable,
                                            @RequestParam(name = "clientId", required = false) String clientId,
                                            @RequestParam(name = "spaceId", required = false) String spaceId,
                                            @RequestParam(name = "proId", required = false) String proId,
                                            @RequestParam(name = "owner", required = false) String owner,
                                            @RequestParam(name = "name", required = false) String name);


    /**
     * @param id 文件id
     * @return
     * @description取消共享
     */
    @DeleteMapping("/{id}")
    boolean deleteShare(@PathVariable(name = "id") String id);

    /**
     * @param opened:0 加密， 1：公开  time: 参考ShareTimeEnum
     * @return
     * @description 共享文件,
     */
    @PostMapping("/storages")
    ShareDto createShares(@RequestBody List<String> storageIds,
                          @RequestParam(name = "clientId", required = false) String clientId,
                          @RequestParam(name = "spaceId", required = false) String spaceId,
                          @RequestParam(name = "time") String time,
                          @RequestParam(name = "opened") int opened,
                          @RequestParam(name = "authority", required = false) String authority);

    /**
     * @param id
     * @return
     * @description 获取共享信息,
     */
    @GetMapping("/{id}")
    ShareDto getShare(@PathVariable(name = "id") String id);

}
