package cn.gtmap.gtc.storage.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/19
 * @description
 */

@Setter
@Getter
public class StorageDto implements Serializable {

    private String id;

    /*
     * 删除状态0 :删除， 1 正常
     * */
    private int enabled;

    /*
     * 0:目录， 1:文件
     * */
    private int type;

    private String name;

    private String owner;

    private String path;

    private String downUrl;

    private int weight;

    private String currentKey;

    private String updatedBy;

    private long currentVersion;

    private long fileSize;

    private String fileType;

    private String storeType;

    private StorageDto parent;

    private ShareDto share;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateAt;
}
