package cn.gtmap.gtc.storage.domain.dto;

import cn.gtmap.gtc.common.http.result.ClassicLinkWrapper;
import cn.gtmap.gtc.common.http.result.LinkResult;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2018/9/19
 * @description
 */

@Getter
@Setter
public class ShareDto extends LinkResult<ClassicLinkWrapper> implements Serializable {

    private String id;

    private String name;

    private int enabled;

    private String owner;

    private String password;

    private String url;

    private String scope;

    private String scopeDesc;

    private String authority;

    /*
     * 下载次数
     * */
    private int count = 0;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createAt;

    private String createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expiryDate;

    //提取码认证结果
    private boolean authorized;

    //随机标识码，用于获取提取码认证结果
    private String flag;

    //是否到期（1：到期，否则，未到期）
    private int expired;

    private List<StorageDto> storages;
}
