package cn.gtmap.gtc.storage.clients.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.storage.domain.dto.ShareDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author zenglihuan
 * @create 2018/10/18 14:27
 * @discription
 **/
@FeignClient(name = "storage-app")
@RequestMapping("/storage/public/rest/v1/shares")
public interface SharePublicClient {

    @GetMapping("/{id}/secret")
    public String generateSecret(@PathVariable(name = "id") String id);

    @GetMapping("/{id}")
    ShareDto getShareSafe(@PathVariable(name = "id") String id);

    @GetMapping("/{id}/owner")
    String getOwnerSafe(@PathVariable(name = "id") String id);

    @PostMapping("/{id}/validation")
    boolean validate(@PathVariable(name = "id") String id, @RequestParam(name = "password") String password);

    @GetMapping("/{id}/node-path")
    List<StorageDto> getNodePath(@PathVariable(name = "id") String id, @RequestParam(name = "nodeId") String nodeId);

    @GetMapping("/subset")
    PageResult<StorageDto> listSubsetStorages(Pageable pageable, @RequestParam(name = "id") String id);

    @PostMapping("/{id}/download-count")
    ShareDto addDownloadCount(@PathVariable(name = "id") String id);
}
