package cn.gtmap.gtc.storage.clients.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.storage.domain.dto.HistoryDto;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zenglihuan
 * @create 2018/11/6 16:36
 * @discription 文档历史版本
 **/
@FeignClient(name = "storage-app")
@RequestMapping("/storage/rest/v1/histories")
public interface HistoryClient {

    @GetMapping
    public List<HistoryDto> findHistoriesByStorage(@RequestParam(name = "storageId") String storageId, @RequestParam(name = "recent") int recent);

    @GetMapping("/{id}")
    public HistoryDto findById(@PathVariable(name = "id") String id);

}
