/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.message.producer;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.rabbit.GtcRabbitEnum;
import cn.gtmap.gtc.start.config.message.producer.MessageProducer;
import cn.gtmap.gtc.start.config.message.producer.MessageSource;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbiMsgProducer
implements MessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(RabbiMsgProducer.class);
    private final RabbitTemplate rabbitTemplate;

    public RabbiMsgProducer(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void send(MessageSource msg) {
        if (null != msg) {
            try {
                String json = ObjectMapperUtils.toJson((Object)msg);
                if (logger.isDebugEnabled()) {
                    logger.debug("MessageSender:{}", (Object)json);
                }
                CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                this.rabbitTemplate.convertAndSend(GtcRabbitEnum.ExchangeName.UAC_MESSAGE_PRODUCE.getName(), GtcRabbitEnum.QueueName.PRODUCE_QUEUE.getRoutingKey(), (Object)json, correlationData);
            }
            catch (Exception e) {
                logger.error("send", (Throwable)e);
            }
        } else {
            logger.error("send emtpy message");
        }
    }
}

