/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.message.producer;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.message.producer.MessageProducer;
import cn.gtmap.gtc.start.config.message.producer.MessageSource;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class HttpMsgProducer
implements MessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(HttpMsgProducer.class);
    private static final String MSG_APP_SERVICE_ID = "message-app";
    private final DiscoveryClient discoveryClient;

    public HttpMsgProducer(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public void send(MessageSource msg) {
        if (null != msg) {
            List instances;
            String json = ObjectMapperUtils.toJson((Object)msg);
            if (logger.isDebugEnabled()) {
                logger.debug("MessageSender:{}", (Object)json);
            }
            if (!CollectionUtils.isEmpty((Collection)(instances = this.discoveryClient.getInstances(MSG_APP_SERVICE_ID)))) {
                Random random = new Random();
                int n = random.nextInt(instances.size());
                ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
                String ipaAndPort = serviceInstance.getHost() + ":" + serviceInstance.getPort();
                String requestUrl = "http://".concat(ipaAndPort).concat("/rest/v1/messages");
                String res = HttpUtils.postJsonParams((String)requestUrl, (String)json);
                if (logger.isDebugEnabled()) {
                    logger.debug("MessageSender result:{}", (Object)res);
                }
            }
        } else {
            logger.error("send emtpy message");
        }
    }
}

