/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.message;

import cn.gtmap.gtc.start.config.audit.rabbit.GtcRabbitEnum;
import cn.gtmap.gtc.start.config.message.consumer.NotifyConsumer;
import cn.gtmap.gtc.start.config.message.consumer.NotifyMsgSource;
import cn.gtmap.gtc.start.config.message.producer.HttpMsgProducer;
import cn.gtmap.gtc.start.config.message.producer.MessageProducer;
import cn.gtmap.gtc.start.config.message.producer.RabbiMsgProducer;
import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
public class GtcMessageAutoConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(GtcMessageAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"messageProducer"})
    public MessageProducer messageProducer(DiscoveryClient discoveryClient) {
        return new HttpMsgProducer(discoveryClient);
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate"})
    @ConditionalOnProperty(name={"message.consumer.type"}, havingValue="rabbit")
    @Import(value={RabbitAutoConfiguration.class})
    public static class GtcMessageConsumerConfiguration {
        private final RabbitTemplate rabbitTemplate;
        private final NotifyConsumer notifyConsumer;
        @Value(value="${spring.application.name}")
        private String clientId;

        public GtcMessageConsumerConfiguration(RabbitTemplate rabbitTemplate, NotifyConsumer notifyConsumer) {
            this.rabbitTemplate = rabbitTemplate;
            this.notifyConsumer = notifyConsumer;
        }

        private String getQueueName() {
            return GtcRabbitEnum.QueueName.FANOUT_NOTIFY_QUEUE.getName() + this.clientId;
        }

        @Bean(value={"notifyFanoutExchange"})
        FanoutExchange notifyFanoutExchange(RabbitAdmin rabbitAdmin) {
            FanoutExchange exchange = new FanoutExchange(GtcRabbitEnum.ExchangeName.MESSAGE_FANOUT_NOTIFY.getName());
            rabbitAdmin.declareExchange((Exchange)exchange);
            return exchange;
        }

        @Bean(value={"notifyDirectExchange"})
        DirectExchange notifyDirectExchange(RabbitAdmin rabbitAdmin) {
            DirectExchange exchange = new DirectExchange(GtcRabbitEnum.ExchangeName.MESSAGE_DIRECT_NOTIFY.getName());
            rabbitAdmin.declareExchange((Exchange)exchange);
            return exchange;
        }

        @Bean
        Queue notifyQueue(RabbitAdmin rabbitAdmin) {
            Queue queue = new Queue(this.getQueueName(), true, false, false, null);
            rabbitAdmin.declareQueue(queue);
            return queue;
        }

        @Bean
        Binding bindingDirectNotifyQueue(RabbitAdmin rabbitAdmin) {
            Binding binding = BindingBuilder.bind((Queue)this.notifyQueue(rabbitAdmin)).to(this.notifyDirectExchange(rabbitAdmin)).with(this.clientId);
            rabbitAdmin.declareBinding(binding);
            return binding;
        }

        @Bean
        Binding bindingNotifyQueue(RabbitAdmin rabbitAdmin) {
            Binding binding = BindingBuilder.bind((Queue)this.notifyQueue(rabbitAdmin)).to(this.notifyFanoutExchange(rabbitAdmin));
            rabbitAdmin.declareBinding(binding);
            return binding;
        }

        public ChannelAwareMessageListener handleService() {
            return new ChannelAwareMessageListener(){

                public void onMessage(Message message, Channel channel) throws Exception {
                    try {
                        String body = new String(message.getBody(), "utf-8");
                        logger.debug("\u6d88\u606f\u56de\u8c03\u901a\u77e5:{}", (Object)body);
                        NotifyMsgSource notify = (NotifyMsgSource)JSON.parseObject((String)body, NotifyMsgSource.class);
                        notifyConsumer.recNotify(notify);
                    }
                    catch (Exception e) {
                        logger.warn("notify.onMessagqe", (Throwable)e);
                    }
                }
            };
        }

        @Bean(value={"notifyMessageContainer"})
        public SimpleMessageListenerContainer notifyMessageContainer(ConnectionFactory connectionFactory) {
            SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(connectionFactory);
            container.setQueueNames(new String[]{this.getQueueName()});
            container.setMessageListener((MessageListener)this.handleService());
            container.setAcknowledgeMode(AcknowledgeMode.AUTO);
            return container;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate"})
    @ConditionalOnProperty(prefix="message.sender", name={"type"}, havingValue="rabbit", matchIfMissing=true)
    @Import(value={RabbitAutoConfiguration.class})
    protected static class RabbitMsgSenderConfiguration {
        protected RabbitMsgSenderConfiguration() {
        }

        @Bean
        public MessageProducer messageProducer(RabbitTemplate rabbitTemplate) {
            return new RabbiMsgProducer(rabbitTemplate);
        }
    }
}

