/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit.sender;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.rabbit.GtcRabbitEnum;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.util.StringUtils;

public class RabbitmqLogSender
implements LogSender {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqLogSender.class);
    private final RabbitTemplate rabbitTemplate;

    public RabbitmqLogSender(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void send(String index, String id, String type, String operate, String jsonData) {
        if (!StringUtils.isEmpty((Object)jsonData)) {
            HashMap<String, String> log = new HashMap<String, String>();
            if (!StringUtils.isEmpty((Object)id)) {
                log.put("id", id);
            }
            if (!StringUtils.isEmpty((Object)index)) {
                log.put("index", index);
            }
            if (StringUtils.isEmpty((Object)operate)) {
                operate = "save";
            }
            log.put("operate", operate);
            if (!StringUtils.isEmpty((Object)type)) {
                log.put("type", type);
            }
            log.put("jsonData", jsonData);
            try {
                CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                this.rabbitTemplate.convertAndSend(GtcRabbitEnum.ExchangeName.ES_RECORD_PRODUCE.getName(), GtcRabbitEnum.QueueName.ES_RECORD_QUEUE.getRoutingKey(), (Object)ObjectMapperUtils.toJson(log), correlationData);
            }
            catch (Exception e) {
                logger.error("RabbitmqLogSender", (Throwable)e);
            }
        } else {
            logger.error("RabbitmqLogSender send empty json data!");
        }
    }
}

