/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit.sender;

import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class HttpLogSender
implements LogSender {
    private static final String LOG_APP_SERVICE_ID = "log-app";
    private final DiscoveryClient discoveryClient;

    public HttpLogSender(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public void send(String index, String id, String type, String operate, String jsonData) {
        List instances = this.discoveryClient.getInstances(LOG_APP_SERVICE_ID);
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance = (ServiceInstance)instances.get(n);
            String ipaAndPort = serviceInstance.getHost() + ":" + serviceInstance.getPort();
            String requestUrl = "http://".concat(ipaAndPort).concat("/rest/v1/customs").concat("?index=");
            if (!StringUtils.isEmpty((Object)index)) {
                requestUrl.concat(index);
            }
            if (!StringUtils.isEmpty((Object)id)) {
                requestUrl.concat("&id=").concat(id);
            }
            HttpUtils.postJsonParams((String)requestUrl, (String)jsonData);
        }
    }
}

