/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.LogClassifyAnalysis;
import cn.gtmap.gtc.start.config.audit.LogClassifyProperties;
import cn.gtmap.gtc.start.config.audit.collector.DefaultLogCollector;
import cn.gtmap.gtc.start.config.audit.collector.LogCollector;
import cn.gtmap.gtc.start.config.audit.log.LogSource;
import cn.gtmap.gtc.start.config.audit.sender.LocalLogSender;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import com.alibaba.fastjson.JSON;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ZipkinAuditEventRepository
implements AuditEventRepository {
    private static final Logger logger = LoggerFactory.getLogger(ZipkinAuditEventRepository.class);
    private final String appName;
    private final LogClassifyProperties logClassifyProperties;
    private final LogSender logSender;
    private final LogCollector logCollector;

    public ZipkinAuditEventRepository(String appName, LogClassifyProperties logClassifyProperties, LogSender logSender, LogCollector logCollector) {
        this.appName = appName;
        this.logClassifyProperties = logClassifyProperties;
        this.logCollector = logCollector != null ? logCollector : new DefaultLogCollector();
        this.logSender = logSender != null ? logSender : new LocalLogSender();
    }

    public void add(AuditEvent event) {
        Assert.notNull((Object)event, (String)"AuditEvent must not be null");
        try {
            if (this.logSender == null) {
                logger.error("ZipkinAudit not config sender!");
                return;
            }
            Map<String, Object> data = this.logCollector.collect(event.getData());
            if (!StringUtils.isEmpty((Object)event.getPrincipal())) {
                data.put("principal", event.getPrincipal());
            }
            data.put("event", event.getType());
            if (StringUtils.isEmpty((Object)data.get("logClassify")) && this.logClassifyProperties != null) {
                String requestUrl = ClientIpUtils.getRequestUrl(null);
                String classify = LogClassifyAnalysis.getClassify(requestUrl, this.logClassifyProperties);
                data.put("logClassify", classify);
            }
            if (!StringUtils.isEmpty((Object)this.appName)) {
                data.put("gtcAppName", this.appName);
            }
            LogSource source = this.conventLogSource(data);
            source.setId(UUID.randomUUID().toString());
            this.logSender.send(null, source.getId(), "platform", "save", JSON.toJSONString((Object)source));
        }
        catch (Exception e) {
            logger.warn("add", (Throwable)e);
        }
    }

    private LogSource conventLogSource(Map<String, Object> data) {
        LogSource source = new LogSource();
        if (data.get("current.url") != null) {
            source.setName(data.get("current.url").toString());
        }
        data.remove("current.url");
        if (data.get("current.method") != null) {
            source.setMethod(data.get("current.method").toString());
        }
        data.remove("current.method");
        source.setTimestamp_millis((Date)data.get("timestamp"));
        data.remove("timestamp");
        source.setTimestamp((Long)data.get("timestamp_millis"));
        data.remove("timestamp_millis");
        LinkedList<String> p = new LinkedList<String>();
        Iterator<Map.Entry<String, Object>> it = data.entrySet().iterator();
        HashMap<String, String> tags = new HashMap<String, String>();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            p.add(entry.getKey());
            String value = this.buildValue(entry.getValue());
            if (value.length() <= 256) {
                p.add(entry.getKey().concat("=").concat(value));
            }
            tags.put(entry.getKey(), value);
        }
        source.set_q(p);
        source.setTags(tags);
        return source;
    }

    public String buildValue(Object arg) {
        String className;
        if (null == arg) {
            return "unknown";
        }
        switch (className = arg.getClass().getName()) {
            case "java.lang.String": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": 
            case "java.lang.Byte": {
                return arg.toString();
            }
        }
        return ObjectMapperUtils.toJson((Object)arg);
    }

    public List<AuditEvent> find(String principal, Instant after, String type) {
        return Collections.emptyList();
    }

    public void newSpanTag(AuditEvent event, String spanName) {
        this.add(event);
    }

    public List<AuditEvent> find(Date after) {
        return this.find(null, after, null);
    }

    public List<AuditEvent> find(String principal, Date after) {
        return this.find(principal, after, null);
    }

    public List<AuditEvent> find(String principal, Date after, String type) {
        return Collections.emptyList();
    }
}

