/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.start.config.audit.LogClassifyProperties;
import java.util.Map;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class LogClassifyAnalysis {
    public static final String REMOTE_ADDR = "remoteAddr";
    public static final String PRINCIPAL = "principal";
    public static final String EVENT = "event";
    public static final String METHOD = "current.method";
    public static final String URL = "current.url";
    public static final String LOG_CLASSIFY = "logClassify";
    public static final String APP_NAME = "gtcAppName";
    public static final String NEW_SPAN = "newSpan";

    public static String getClassify(String requestUrl, LogClassifyProperties logClassifyProperties) {
        String classify = logClassifyProperties.getDefaulted();
        if (!StringUtils.isEmpty((Object)requestUrl) && !CollectionUtils.isEmpty(logClassifyProperties.getPath())) {
            AntPathMatcher matcher = new AntPathMatcher();
            for (Map.Entry<String, String[]> entry : logClassifyProperties.getPath().entrySet()) {
                if (!LogClassifyAnalysis.matchUrl((PathMatcher)matcher, entry.getValue(), requestUrl)) continue;
                return entry.getKey();
            }
        }
        return classify;
    }

    public static boolean matchUrl(PathMatcher matcher, String[] urls, String requestUrl) {
        if (urls != null) {
            for (String url : urls) {
                if (!matcher.match(url, requestUrl)) continue;
                return true;
            }
        }
        return false;
    }
}

