/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.collector.DefaultLogCollector;
import cn.gtmap.gtc.start.config.audit.collector.LogCollector;
import cn.gtmap.gtc.start.config.audit.sender.LocalLogSender;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuditEventRepository {
    private static final Logger logger = LoggerFactory.getLogger(CustomAuditEventRepository.class);
    private final LogSender logSender;
    private final LogCollector logCollector;

    public CustomAuditEventRepository(LogSender logSender, LogCollector logCollector) {
        this.logCollector = logCollector != null ? logCollector : new DefaultLogCollector();
        this.logSender = logSender != null ? logSender : new LocalLogSender();
    }

    public void add(String index, String id, Map<String, Object> data) {
        try {
            if (this.logSender == null) {
                logger.error("CustomAuditLog not config sender!");
                return;
            }
            data = this.logCollector.collect(data);
            this.logSender.send(index, id, "custom", "save", ObjectMapperUtils.toJson(data));
        }
        catch (Exception e) {
            logger.warn("add", (Throwable)e);
        }
    }
}

