/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.start.config.audit.AuthenticationAuditListener;
import cn.gtmap.gtc.start.config.audit.AuthorizationAuditListener;
import cn.gtmap.gtc.start.config.audit.CustomAuditEventRepository;
import cn.gtmap.gtc.start.config.audit.LogClassifyProperties;
import cn.gtmap.gtc.start.config.audit.ZipkinAuditEventRepository;
import cn.gtmap.gtc.start.config.audit.collector.DefaultLogCollector;
import cn.gtmap.gtc.start.config.audit.collector.LogCollector;
import cn.gtmap.gtc.start.config.audit.collector.SecurityLogCollector;
import cn.gtmap.gtc.start.config.audit.sender.LocalLogSender;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import cn.gtmap.gtc.start.config.audit.sender.RabbitmqLogSender;
import com.rabbitmq.client.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AbstractAuditListener;
import org.springframework.boot.actuate.audit.listener.AuditListener;
import org.springframework.boot.actuate.security.AbstractAuthenticationAuditListener;
import org.springframework.boot.actuate.security.AbstractAuthorizationAuditListener;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import zipkin2.reporter.Sender;
import zipkin2.reporter.amqp.RabbitMQSender;

@Configuration
@EnableConfigurationProperties(value={LogClassifyProperties.class})
public class AuditAutoConfiguration {
    @Value(value="${spring.application.name:}")
    private String appName;
    @Value(value="${logging.security.collection.authorizationSuccess:false}")
    private boolean authorizationSuccess;
    @Value(value="${logging.security.collection.authenticationSuccess:false}")
    private boolean authenticationSuccess;

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.authentication.event.AbstractAuthenticationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthenticationAuditListener.class})
    public AuthenticationAuditListener authenticationAuditListener() throws Exception {
        return new AuthenticationAuditListener(this.authenticationSuccess);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.access.event.AbstractAuthorizationEvent"})
    @ConditionalOnMissingBean(value={AbstractAuthorizationAuditListener.class})
    public AuthorizationAuditListener authorizationAuditListener() throws Exception {
        return new AuthorizationAuditListener(this.authorizationSuccess);
    }

    @Bean
    @ConditionalOnMissingBean(value={LogSender.class})
    public LogSender logSender() {
        return new LocalLogSender();
    }

    @Bean
    @ConditionalOnMissingBean
    public LogCollector logCollector() {
        return new DefaultLogCollector();
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractAuditListener.class})
    public AuditListener auditListener(LogClassifyProperties logClassifyProperties, LogSender logSender, LogCollector logCollector) throws Exception {
        return new AuditListener((AuditEventRepository)this.zipkinAuditEventRepository(logClassifyProperties, logSender, logCollector));
    }

    @Bean
    @ConditionalOnMissingBean(value={AuditEventRepository.class})
    public ZipkinAuditEventRepository zipkinAuditEventRepository(LogClassifyProperties logClassifyProperties, LogSender logSender, LogCollector logCollector) {
        return new ZipkinAuditEventRepository(this.appName, logClassifyProperties, logSender, logCollector);
    }

    @Bean
    public CustomAuditEventRepository customAuditEventRepository(LogClassifyProperties logClassifyProperties, LogSender logSender, LogCollector logCollector) {
        return new CustomAuditEventRepository(logSender, logCollector);
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    protected static class SecurityLogCollectorCfg {
        protected SecurityLogCollectorCfg() {
        }

        @Bean
        public LogCollector logCollector() {
            return new SecurityLogCollector();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate", "zipkin2.reporter.Sender"})
    @ConditionalOnProperty(prefix="spring.zipkin.sender", name={"type"}, havingValue="rabbit", matchIfMissing=true)
    @Import(value={RabbitAutoConfiguration.class})
    protected static class RabbitZipkinConfiguration {
        protected RabbitZipkinConfiguration() {
        }

        @Bean
        public Sender zipkinSender2(RabbitProperties rabbitProperties) {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setHost(rabbitProperties.getHost());
            connectionFactory.setPort(rabbitProperties.getPort());
            connectionFactory.setPassword(rabbitProperties.getPassword());
            connectionFactory.setUsername(rabbitProperties.getUsername());
            String addr = rabbitProperties.getAddresses();
            if (StringUtils.isEmpty((Object)rabbitProperties.getAddresses())) {
                addr = rabbitProperties.getHost() + ":" + rabbitProperties.getPort();
            }
            return RabbitMQSender.newBuilder().connectionFactory(connectionFactory).queue("zipkin").addresses(addr).build();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate"})
    @ConditionalOnProperty(prefix="logging.store", name={"type"}, havingValue="rabbit", matchIfMissing=true)
    @Import(value={RabbitAutoConfiguration.class})
    protected static class RabbitLogConfiguration {
        protected RabbitLogConfiguration() {
        }

        @Bean
        public LogSender logSender(RabbitTemplate rabbitTemplate) {
            return new RabbitmqLogSender(rabbitTemplate);
        }
    }
}

