package cn.gtmap.gtc.start.config.message.producer;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.rabbit.GtcRabbitEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

import java.util.UUID;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-14
 * @description
 */
public class RabbiMsgProducer implements MessageProducer{

    private static final Logger logger = LoggerFactory.getLogger(RabbiMsgProducer.class);


    private final RabbitTemplate rabbitTemplate;

    public RabbiMsgProducer(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void send(MessageSource msg) {
        if (null != msg) {
            try {
                String json = ObjectMapperUtils.toJson(msg);
                if (logger.isDebugEnabled()) {
                    logger.debug("MessageSender:{}", json);
                }
                CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
                this.rabbitTemplate.convertAndSend(GtcRabbitEnum.ExchangeName.UAC_MESSAGE_PRODUCE.getName(),
                        GtcRabbitEnum.QueueName.PRODUCE_QUEUE.getRoutingKey(),
                        json,
                        correlationData);
            } catch (Exception e){
                logger.error("send", e);
            }
        } else {
            logger.error("send emtpy message");
        }
    }
}
