package cn.gtmap.gtc.start.config.message.producer;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-14
 * @description
 */
public class MessageSource implements Serializable {

    /*
     *  应用标识ID
     * */
    private String clientId;

    /*
     *  业务系统定义消息编码,和 应用标识ID 做唯一标识
     * */
    private String msgCode;

    /*
     *  消息类型，由业务系统自定义
     * */
    private String msgType;

    /*
     *  消息类型名称，由业务系统自定义
     * */
    private String msgTypeName;

    /*
     *  标题
     * */
    private String msgTitle;

    /*
     *  内容
     * */
    private String msgContent;

    /*
     * 是否已读  0：未读, 1: 已读, 2: 不设置
     * */

    private int read;

    /*
     *  消息发布者
     *  ClientDto.getClientId()
     *  OrganizationDto.getId()
     *  RoleDto.getId()
     *  UserDto.getUsername()
     * */
    private String producer;

    /*
     *  发布者类型：
     *  system: 系统平台
     *  organization: 组织
     *  role: 角色
     *  personal: 个人
     * */
    private String producerType;

    /*  消费者类型
     *  organization: 组织
     *  role: 角色
     *  personal: 个人
     *  anonymous：匿名用户非平台用户
     * */
    private String consumerType;


    /*
     *  消息消费者, 最终将转化成用户处理
     *  OrganizationDto.getId()
     *  RoleDto.getId()
     *  UserDto.getUsername()
     * */
    private String consumer;


    /*
     *  消息处理
     *
     *  delete, save, email, sms
     * */
    private String options;

    /*
     *  开始处理时间
     * */
    private Date optStartTime;

    /*
     *  结束处理时间
     * */
    private Date optEndTime;

    /*
     *  email, sms 定时消息处理时间，如果为空，则立即处理
     * */
    private Date optTime;

    /*
     *  消息处理后通知方式
     *
     *  rabbitmq, restfull, 为空不回调
     * */
    private String notifyType;

    /*
     *  restfull 通知地址
     * */
    private String httpNotifyUrl;

    /*
     *  http 回调方式
     *  balanced: 负载均衡模式，使用appName
     *  normal: 普通模式， ip:port
     * */
    private String httpLoadType;

    /**
     * 短信模板构建方式 1:本地配置文件 2.短信模板库
     */
    private int smsBuildType = 1;

    /*
    *  模板ID 当 smsBuildType = 2 时启用
    * */
    private String templateId;

    public String getClientId() {
        return clientId;
    }

    public MessageSource setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getMsgCode() {
        return msgCode;
    }

    public MessageSource setMsgCode(String msgCode) {
        this.msgCode = msgCode;
        return this;
    }

    public String getMsgType() {
        return msgType;
    }

    public MessageSource setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public String getMsgTypeName() {
        return msgTypeName;
    }

    public MessageSource setMsgTypeName(String msgTypeName) {
        this.msgTypeName = msgTypeName;
        return this;
    }

    public String getMsgTitle() {
        return msgTitle;
    }

    public MessageSource setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
        return this;
    }

    public String getMsgContent() {
        return msgContent;
    }

    public MessageSource setMsgContent(String msgContent) {
        this.msgContent = msgContent;
        return this;
    }

    public int getRead() {
        return read;
    }

    public MessageSource setRead(int read) {
        this.read = read;
        return this;
    }

    public String getProducer() {
        return producer;
    }

    public MessageSource setProducer(String producer) {
        this.producer = producer;
        return this;
    }

    public String getProducerType() {
        return producerType;
    }

    public MessageSource setProducerType(String producerType) {
        this.producerType = producerType;
        return this;
    }

    public String getConsumerType() {
        return consumerType;
    }

    public MessageSource setConsumerType(String consumerType) {
        this.consumerType = consumerType;
        return this;
    }

    public String getConsumer() {
        return consumer;
    }

    public MessageSource setConsumer(String consumer) {
        this.consumer = consumer;
        return this;
    }

    public String getOptions() {
        return options;
    }

    public MessageSource setOptions(String options) {
        this.options = options;
        return this;
    }

    public Date getOptStartTime() {
        return optStartTime;
    }

    public MessageSource setOptStartTime(Date optStartTime) {
        this.optStartTime = optStartTime;
        return this;
    }

    public Date getOptEndTime() {
        return optEndTime;
    }

    public MessageSource setOptEndTime(Date optEndTime) {
        this.optEndTime = optEndTime;
        return this;
    }

    public Date getOptTime() {
        return optTime;
    }

    public MessageSource setOptTime(Date optTime) {
        this.optTime = optTime;
        return this;
    }

    public String getNotifyType() {
        return notifyType;
    }

    public MessageSource setNotifyType(String notifyType) {
        this.notifyType = notifyType;
        return this;
    }

    public String getHttpNotifyUrl() {
        return httpNotifyUrl;
    }

    public MessageSource setHttpNotifyUrl(String httpNotifyUrl) {
        this.httpNotifyUrl = httpNotifyUrl;
        return this;
    }

    public String getHttpLoadType() {
        return httpLoadType;
    }

    public MessageSource setHttpLoadType(String httpLoadType) {
        this.httpLoadType = httpLoadType;
        return this;
    }

    public int getSmsBuildType() {
        return smsBuildType;
    }

    public MessageSource setSmsBuildType(int smsBuildType) {
        this.smsBuildType = smsBuildType;
        return this;
    }

    public String getTemplateId() {
        return templateId;
    }

    public MessageSource setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }
}
