package cn.gtmap.gtc.start.config.message.producer;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Random;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-14
 * @description
 */
public class HttpMsgProducer implements MessageProducer {

    private static final Logger logger = LoggerFactory.getLogger(HttpMsgProducer.class);
    private static final String MSG_APP_SERVICE_ID = "message-app";

    private final DiscoveryClient discoveryClient;
    public HttpMsgProducer(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public void send(MessageSource msg) {
        if (null != msg) {
            String json = ObjectMapperUtils.toJson(msg);
            if (logger.isDebugEnabled()) {
                logger.debug("MessageSender:{}", json);
            }

            List<ServiceInstance> instances = discoveryClient.getInstances(MSG_APP_SERVICE_ID);
            if (!CollectionUtils.isEmpty(instances)) {
                Random random = new Random();
                int n = random.nextInt(instances.size());
                ServiceInstance serviceInstance= instances.get(n);
                String ipaAndPort= serviceInstance.getHost()+":"+serviceInstance.getPort();
                String requestUrl = "http://".concat(ipaAndPort)
                        .concat("/rest/v1/messages");

                String res = HttpUtils.postJsonParams(requestUrl, json);
                if (logger.isDebugEnabled()) {
                    logger.debug("MessageSender result:{}", res);
                }
            }
        }else {
            logger.error("send emtpy message");
        }

    }
}
