package cn.gtmap.gtc.start.config.message.consumer;

import java.io.Serializable;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-14
 * @description
 */
public class NotifyMsgSource implements Serializable {
    /*
     *  消息中心生成唯一消息ID
     * */
    private String msgId;

    /*
     *  处理结果0：成功， 1： 失败
     * */
    private int code = 0;

    /*
     *  处理异常原因
     * */
    private String errorMsg;

    /*
     *  应用标识ID
     * */
    private String clientId;

    /*
     *  业务系统定义消息编码,和 应用标识ID 做唯一标识
     * */
    private String msgCode;

    /*
     *  消息类型，由业务系统自定义
     * */
    private String msgType;

    /*
     *  消息类型名称，由业务系统自定义
     * */
    private String msgTypeName;

    /*
     *  消息发布者
     * */
    private String producer;

    /*
     *  发布者类型：
     *  system: 系统平台
     *  organization: 组织
     *  role: 角色
     *  personal: 个人
     * */
    private String producerType;


    /*
     *  消息消费者用户名
     * */
    private String recUsername;

    /*
     *  标题
     * */
    private String msgTitle;

    /*
     *  消息内容
     * */
    private String msgContent;

    /*
     *  消息处理方式
     *
     *  delete, save, email, sms
     * */
    private String option;
    public String getMsgId() {
        return msgId;
    }

    public NotifyMsgSource setMsgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    public int getCode() {
        return code;
    }

    public NotifyMsgSource setCode(int code) {
        this.code = code;
        return this;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public NotifyMsgSource setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public NotifyMsgSource setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getMsgCode() {
        return msgCode;
    }

    public NotifyMsgSource setMsgCode(String msgCode) {
        this.msgCode = msgCode;
        return this;
    }

    public String getMsgType() {
        return msgType;
    }

    public NotifyMsgSource setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public String getMsgTypeName() {
        return msgTypeName;
    }

    public NotifyMsgSource setMsgTypeName(String msgTypeName) {
        this.msgTypeName = msgTypeName;
        return this;
    }

    public String getProducer() {
        return producer;
    }

    public NotifyMsgSource setProducer(String producer) {
        this.producer = producer;
        return this;
    }

    public String getProducerType() {
        return producerType;
    }

    public NotifyMsgSource setProducerType(String producerType) {
        this.producerType = producerType;
        return this;
    }

    public String getRecUsername() {
        return recUsername;
    }

    public NotifyMsgSource setRecUsername(String recUsername) {
        this.recUsername = recUsername;
        return this;
    }

    public String getMsgTitle() {
        return msgTitle;
    }

    public NotifyMsgSource setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
        return this;
    }

    public String getMsgContent() {
        return msgContent;
    }

    public NotifyMsgSource setMsgContent(String msgContent) {
        this.msgContent = msgContent;
        return this;
    }

    public String getOption() {
        return option;
    }

    public NotifyMsgSource setOption(String option) {
        this.option = option;
        return this;
    }
}
