package cn.gtmap.gtc.start.config.audit.sender;

import cn.gtmap.gtc.starter.gcas.util.HttpUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Random;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-12
 * @description
 */
public class HttpLogSender implements LogSender{
    private static final String LOG_APP_SERVICE_ID = "log-app";
    private final DiscoveryClient discoveryClient;

    public HttpLogSender(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @Override
    public void send(String index, String id, String type, String operate, String jsonData) {
        //http方式创建索引
        List<ServiceInstance> instances = discoveryClient.getInstances(LOG_APP_SERVICE_ID);
        if (!CollectionUtils.isEmpty(instances)) {
            Random random = new Random();
            int n = random.nextInt(instances.size());
            ServiceInstance serviceInstance= instances.get(n);
            String ipaAndPort= serviceInstance.getHost()+":"+serviceInstance.getPort();
            String requestUrl = "http://".concat(ipaAndPort)
                    .concat("/rest/v1/customs")
                    .concat("?index=");
            if (!StringUtils.isEmpty(index)){
                requestUrl.concat(index);
            }
            if (!StringUtils.isEmpty(id)){
                requestUrl.concat("&id=").concat(id);
            }
            HttpUtils.postJsonParams(requestUrl, jsonData);
        }
    }
}
