package cn.gtmap.gtc.start.config.audit.rabbit;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/3/13
 * @description
 */

@Configuration
@ConditionalOnClass(name = {"org.springframework.amqp.rabbit.core.RabbitTemplate"})
@Import(org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration.class)
public class RabbitMqConfig {
    @Bean
    @ConditionalOnMissingBean
    public org.springframework.amqp.rabbit.core.RabbitAdmin  rabbitAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory){
        return new org.springframework.amqp.rabbit.core.RabbitAdmin(connectionFactory);
    }
}
