package cn.gtmap.gtc.start.config.audit.rabbit;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-14
 * @description
 */
public class   GtcRabbitEnum {

    public enum ExchangeName {
        UAC_MESSAGE_PRODUCE("uac.message.produce", "消息生产"),
        MESSAGE_FANOUT_NOTIFY("message.fanout.notify", "消息回调通知"),
        MESSAGE_DIRECT_NOTIFY("message.direct.notify", "消息回调通知"),
        ES_RECORD_PRODUCE("es.record.produce", "自定义ES消息");
        private String name;
        private String remark;

        ExchangeName(String name, String remark) {
            this.name = name;
            this.remark = remark;
        }

        public String getRemark() {
            return remark;
        }

        public String getName() {
            return name;
        }
    }

    public enum QueueName {
        PRODUCE_QUEUE("uac.message.produce.queue", "produce", "消息生成"),
        FANOUT_NOTIFY_QUEUE("fanout.notify.", "fanout.notify", "消息回调通知"),
        ES_RECORD_QUEUE("es.record.queue", "es", "自定义ES消息");
        private String name;
        private String routingKey;
        private String remark;

        QueueName(String name, String routingKey, String remark) {
            this.name = name;
            this.routingKey = routingKey;
            this.remark = remark;
        }

        public String getName() {
            return name;
        }

        public String getRoutingKey() {
            return routingKey;
        }

        public String getRemark() {
            return remark;
        }
    }
}
