package cn.gtmap.gtc.start.config.audit.collector;

import cn.gtmap.gtc.start.config.audit.LogClassifyAnalysis;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-12
 * @description
 */
public class SecurityLogCollector implements LogCollector {

    private DefaultLogCollector collector = new DefaultLogCollector();

    @Override
    public Map<String, Object> collect(Map<String, Object> map) {
        Map<String, Object> data = collector.collect(map);

        //添加PRINCIPAL
        if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.PRINCIPAL))) {
            String principal = "unknown";
            if (SecurityContextHolder.getContext() != null &&   SecurityContextHolder.getContext().getAuthentication() != null) {
                principal = SecurityContextHolder.getContext().getAuthentication().getName();
            }
            data.put(LogClassifyAnalysis.PRINCIPAL,principal);
        }
        return data;
    }
}
