package cn.gtmap.gtc.start.config.audit.collector;

import cn.gtmap.gtc.start.config.audit.LogClassifyAnalysis;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-5-12
 * @description
 */
public class DefaultLogCollector implements LogCollector {
    @Override
    public Map<String, Object> collect(Map<String, Object> map) {
        Map<String, Object> data = new HashMap<>();
        if (map != null){
            data.putAll(map);
        }
        HttpServletRequest request = ClientIpUtils.getRequest();
        if (request != null){
            //添加REMOTE_ADDR
            if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.REMOTE_ADDR))) {
                data.put(LogClassifyAnalysis.REMOTE_ADDR,ClientIpUtils.getRemoteHost(request));
            }
            //添加URL
            if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.URL))) {
                data.put(LogClassifyAnalysis.URL,ClientIpUtils.getRequestUrl(request));
            }
            //添加METHOD
            if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.METHOD))) {
                data.put(LogClassifyAnalysis.METHOD,ClientIpUtils.getRequestUrl(request));
            }
        }

        //添加EVENT
        if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.EVENT))) {
            data.put(LogClassifyAnalysis.EVENT,"CUSTOM_EVENT");
        }

        //添加timestamp_millis
        if (data.get("timestamp_millis") == null){
            data.put("timestamp_millis",System.currentTimeMillis());
        }

        if (data.get("timestamp") == null){
            data.put("timestamp",new Date());
        }

        return data;
    }
}
