package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.collector.DefaultLogCollector;
import cn.gtmap.gtc.start.config.audit.collector.LogCollector;
import cn.gtmap.gtc.start.config.audit.log.LogSource;
import cn.gtmap.gtc.start.config.audit.sender.LocalLogSender;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.util.*;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0, 2018/7/17
 * @description
 */
public class ZipkinAuditEventRepository implements AuditEventRepository {
    private static final  Logger logger = LoggerFactory.getLogger(ZipkinAuditEventRepository.class);

    private final String appName;
    private final LogClassifyProperties logClassifyProperties;
    private final LogSender logSender;
    private final LogCollector logCollector;

    public ZipkinAuditEventRepository(String appName, LogClassifyProperties logClassifyProperties, LogSender logSender, LogCollector logCollector) {
        this.appName = appName;
        this.logClassifyProperties = logClassifyProperties;
        if (logCollector != null){
            this.logCollector = logCollector;
        } else {
            this.logCollector = new DefaultLogCollector();
        }

        if (logSender != null){
            this.logSender = logSender;
        } else {
            this.logSender = new LocalLogSender();
        }
    }

    public void add(AuditEvent event) {
        Assert.notNull(event, "AuditEvent must not be null");
        try {
            if (logSender == null){
                logger.error("ZipkinAudit not config sender!");
                return;
            }
            //校验参数,补充data参数
            Map<String, Object> data = logCollector.collect(event.getData());
            if (!StringUtils.isEmpty(event.getPrincipal())){
                data.put(LogClassifyAnalysis.PRINCIPAL, event.getPrincipal());
            }
            data.put(LogClassifyAnalysis.EVENT,event.getType());

            if (StringUtils.isEmpty(data.get(LogClassifyAnalysis.LOG_CLASSIFY)) && logClassifyProperties != null){
                String requestUrl = ClientIpUtils.getRequestUrl(null);
                String classify = LogClassifyAnalysis.getClassify(requestUrl, logClassifyProperties);
                data.put(LogClassifyAnalysis.LOG_CLASSIFY,classify);
            }

            if (!StringUtils.isEmpty(appName)){
                data.put(LogClassifyAnalysis.APP_NAME,appName);
            }

            LogSource source = conventLogSource(data);
            source.setId(UUID.randomUUID().toString());

            logSender.send(null, source.getId(), "platform","save", JSON.toJSONString(source));
        } catch (Exception e){
            logger.warn("add", e);
        }
    }

    private LogSource conventLogSource(Map<String,Object> data) {
        LogSource source = new LogSource();
        if (data.get(LogClassifyAnalysis.URL) != null){
            source.setName(data.get(LogClassifyAnalysis.URL).toString());
        }
        data.remove(LogClassifyAnalysis.URL);
        if (data.get(LogClassifyAnalysis.METHOD) != null){
            source.setMethod(data.get(LogClassifyAnalysis.METHOD).toString());
        }
        data.remove(LogClassifyAnalysis.METHOD);

        source.setTimestamp_millis((Date)data.get("timestamp"));
        data.remove("timestamp");
        source.setTimestamp((long)data.get("timestamp_millis"));
        data.remove("timestamp_millis");
        List<String> p = new LinkedList<>();
        Iterator<Map.Entry<String, Object>> it = data.entrySet().iterator();
        Map<String,String> tags = new HashMap<>();
        while(it.hasNext()){
            Map.Entry<String, Object> entry = it.next();
            p.add(entry.getKey());
            String value = buildValue(entry.getValue());
            if (value.length() <= 256){
                p.add(entry.getKey().concat("=").concat(value));
            }
            tags.put(entry.getKey(), value);
        }
        source.set_q(p);
        source.setTags(tags);
        return source;
    }

    public String buildValue(Object arg){
        if(null == arg){
            return "unknown";
        }
        String className = arg.getClass().getName();
        switch (className){
            case "java.lang.String":
            case "java.lang.Integer":
            case "java.lang.Long":
            case "java.lang.Short":
            case "java.lang.Byte":
                return arg.toString();
            default:
                return ObjectMapperUtils.toJson(arg);
        }
    }

    @Override
    public List<AuditEvent> find(String principal, Instant after, String type) {
        return Collections.emptyList();
    }

    public void newSpanTag(AuditEvent event, String spanName){
        add(event);
    }

    public List<AuditEvent> find(Date after) {
        return this.find(null, after, null);
    }

    public List<AuditEvent> find(String principal, Date after) {
        return this.find(principal, after, null);
    }

    public List<AuditEvent> find(String principal, Date after, String type) {
        return Collections.emptyList();
    }

}
