package cn.gtmap.gtc.start.config.audit;

import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2019/5/8
 * @description
 */
public class LogClassifyAnalysis {

    public static final String REMOTE_ADDR = "remoteAddr";
    public static final String PRINCIPAL = "principal";
    public static final String EVENT = "event";
    public static final String METHOD = "current.method";
    public static final String URL = "current.url";
    public static final String LOG_CLASSIFY = "logClassify";
    public static final String APP_NAME = "gtcAppName";
    public static final String NEW_SPAN = "newSpan";

    public static String getClassify(String requestUrl, LogClassifyProperties logClassifyProperties) {
        String classify = logClassifyProperties.getDefaulted();
        if (!StringUtils.isEmpty(requestUrl)) {
            if (!CollectionUtils.isEmpty(logClassifyProperties.getPath())){
                PathMatcher matcher = new AntPathMatcher();
                for (Map.Entry<String, String[]> entry : logClassifyProperties.getPath().entrySet()) {
                    if (matchUrl(matcher, entry.getValue(), requestUrl)){
                        return entry.getKey();
                    }
                }
            }
        }
        return classify;
    }
    public static boolean matchUrl(PathMatcher matcher, String[] urls, String requestUrl){
        if (urls != null) {
            for (String url : urls) {
                if (matcher.match(url, requestUrl)){
                    return true;
                }
            }
        }
        return false;
    }
}
