package cn.gtmap.gtc.start.config.audit;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.start.config.audit.collector.DefaultLogCollector;
import cn.gtmap.gtc.start.config.audit.collector.LogCollector;
import cn.gtmap.gtc.start.config.audit.sender.LocalLogSender;
import cn.gtmap.gtc.start.config.audit.sender.LogSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @date V1.0, 2020-5-14 12:20
 * @description
 */

public class CustomAuditEventRepository {

    private static final Logger logger = LoggerFactory.getLogger(CustomAuditEventRepository.class);

    private final LogSender logSender;
    private final LogCollector logCollector;

    public CustomAuditEventRepository(LogSender logSender, LogCollector logCollector) {
        if (logCollector != null){
            this.logCollector = logCollector;
        } else {
            this.logCollector = new DefaultLogCollector();
        }

        if (logSender != null){
            this.logSender = logSender;
        } else {
            this.logSender = new LocalLogSender();
        }
    }

    /**
     * 存储自定义索引
     * @param index 索引
     * @param id id组件
     * @param data 数据
     */
    public void add(String index, String id, Map<String, Object> data) {
        //Assert.hasLength(index, "参数缺索引值");
        try {
            if (logSender == null){
                logger.error("CustomAuditLog not config sender!");
                return;
            }
            //校验参数,补充data参数
            data = logCollector.collect(data);
            logSender.send(index, id, "custom","save", ObjectMapperUtils.toJson(data));
        } catch (Exception e){
            logger.warn("add", e);
        }
    }
}
