/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.prometheus;

import cn.gtmap.gtc.starter.gcas.prometheus.CustomSupervice;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomSuperviseInit {
    private Logger logger = LoggerFactory.getLogger(CustomSuperviseInit.class);
    @Autowired(required=false)
    private MeterRegistry registry;
    @Autowired(required=false)
    private CustomSupervice customSupervice;
    private Map<String, AtomicDouble> indexMap;
    private static volatile boolean FLAG = false;

    public void init() {
        if (null != this.customSupervice && !FLAG && null != this.registry) {
            Map<String, Double> indexValueMap = this.customSupervice.superviseIndexes();
            this.indexMap = Maps.newConcurrentMap();
            if (!indexValueMap.isEmpty()) {
                FLAG = true;
                for (Map.Entry<String, Double> entry : indexValueMap.entrySet()) {
                    AtomicDouble indexAtomicAtomicDouble = (AtomicDouble)this.registry.gauge(entry.getKey(), (Number)new AtomicDouble(entry.getValue().doubleValue()));
                    this.indexMap.put(entry.getKey(), indexAtomicAtomicDouble);
                    indexAtomicAtomicDouble.set((double)entry.getValue().intValue());
                }
            }
        } else {
            this.logger.debug("customSupervice:{}, registry:{}, FLAG:{}", new Object[]{this.customSupervice, this.registry, FLAG});
        }
    }

    public void superviseIndexes() {
        this.init();
        if (null != this.customSupervice && null != this.registry) {
            Map<String, Double> indexValueMap = this.customSupervice.superviseIndexes();
            for (String key : indexValueMap.keySet()) {
                AtomicDouble indexAtomicAtomicDouble = this.indexMap.get(key);
                indexAtomicAtomicDouble.set(indexValueMap.get(key).doubleValue());
            }
        } else {
            this.logger.debug("customSupervice:{}, registry:{}, FLAG:{}", new Object[]{this.customSupervice, this.registry, FLAG});
        }
    }
}

