/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.config;

import cn.gtmap.gtc.starter.gcas.util.ResourcesMessageUtils;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
public class LocaleConfig {
    @Value(value="${spring.messages.locale:zh_CN}")
    private String lang;

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:lang/messages");
        return messageSource;
    }

    @Bean
    public ResourcesMessageUtils resourcesMessageUtils() {
        return new ResourcesMessageUtils(this.messageSource());
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        Locale locale = Locale.SIMPLIFIED_CHINESE;
        if (!"zh_CN".equals(this.lang) && this.lang.contains("_")) {
            String[] s = this.lang.split("_");
            locale = new Locale(s[0], s[1]);
        }
        localeResolver.setDefaultLocale(locale);
        return localeResolver;
    }

    @Bean(value={"ChangeLocaleInterceptor"})
    public WebMvcConfigurer localeInterceptor() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                LocaleChangeInterceptor localeInterceptor = new LocaleChangeInterceptor();
                localeInterceptor.setParamName("lang");
                registry.addInterceptor((HandlerInterceptor)localeInterceptor);
            }
        };
    }
}

