/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.config;

import cn.gtmap.gtc.feign.common.exception.FeignErrorDecoder;
import cn.gtmap.gtc.starter.gcas.config.handler.SpringMultipartFormEncoder;
import cn.gtmap.gtc.starter.gcas.endpoint.GtcEndpoint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import feign.Logger;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Configuration
public class GTAutoConfiguration {
    @Bean
    public GtcEndpoint gtcEndpoint() {
        return new GtcEndpoint();
    }

    @Bean
    public Encoder feignEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new PageableQueryEncoder((Encoder)new SpringMultipartFormEncoder((Encoder)new SpringEncoder(messageConverters)));
    }

    @Bean
    public ErrorDecoder errorDecoder() {
        return new FeignErrorDecoder();
    }

    @Bean
    public Logger.Level feignLogLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public Module pageJackModule() {
        return new PageJacksonModule();
    }

    public static class DefaultPageImpl<T>
    implements Page<T> {
        private final Page<T> delegate;

        public DefaultPageImpl(@JsonProperty(value="content") List<T> content, @JsonProperty(value="number") int number, @JsonProperty(value="size") int size, @JsonProperty(value="totalElements") long totalElements) {
            this.delegate = new PageImpl(content, (Pageable)PageRequest.of((int)number, (int)size), totalElements);
        }

        @JsonProperty
        public int getTotalPages() {
            return this.delegate.getTotalPages();
        }

        @JsonProperty
        public long getTotalElements() {
            return this.delegate.getTotalElements();
        }

        public int getNumber() {
            return this.delegate.getNumber();
        }

        @JsonProperty
        public int getSize() {
            return this.delegate.getSize();
        }

        @JsonProperty
        public int getNumberOfElements() {
            return this.delegate.getNumberOfElements();
        }

        @JsonProperty
        public List<T> getContent() {
            return this.delegate.getContent();
        }

        @JsonProperty
        public boolean hasContent() {
            return this.delegate.hasContent();
        }

        @JsonIgnore
        public Sort getSort() {
            return this.delegate.getSort();
        }

        @JsonProperty
        public boolean isFirst() {
            return this.delegate.isFirst();
        }

        @JsonProperty
        public boolean isLast() {
            return this.delegate.isLast();
        }

        @JsonIgnore
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @JsonIgnore
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @JsonIgnore
        public Pageable nextPageable() {
            return this.delegate.nextPageable();
        }

        @JsonIgnore
        public Pageable previousPageable() {
            return this.delegate.previousPageable();
        }

        @JsonIgnore
        public <U> Page<U> map(Function<? super T, ? extends U> converter) {
            return this.delegate.map(converter);
        }

        @JsonIgnore
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class PageJacksonModule
    extends SimpleModule {
        public void setupModule(Module.SetupContext context) {
            context.setMixInAnnotations(Page.class, PageMixIn.class);
        }
    }

    @JsonDeserialize(as=DefaultPageImpl.class)
    public static interface PageMixIn {
    }

    public static class PageableQueryEncoder
    implements Encoder {
        private final Encoder delegate;

        public PageableQueryEncoder(Encoder delegate) {
            this.delegate = delegate;
        }

        public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                template.query("page", new String[]{String.valueOf(pageable.getPageNumber())});
                template.query("size", new String[]{String.valueOf(pageable.getPageSize())});
                if (pageable.getSort() != null) {
                    Collection existingSorts = (Collection)template.queries().get("sort");
                    ArrayList<String> sortQueries = existingSorts != null ? new ArrayList<String>(existingSorts) : new ArrayList();
                    for (Sort.Order order : pageable.getSort()) {
                        sortQueries.add(order.getProperty() + "," + order.getDirection());
                    }
                    template.query("sort", sortQueries);
                }
            } else {
                this.delegate.encode(object, bodyType, template);
            }
        }
    }
}

