/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.xss;

import cn.gtmap.gtc.starter.gcas.xss.XssHttpServletRequestWrapper;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class XssObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = -3448961813323784217L;

    public XssObjectMapper() {
        SimpleModule module = new SimpleModule("XssStringJsonSerializer");
        module.addSerializer((JsonSerializer)new JsonHtmlXssSerializer(String.class));
        module.addDeserializer(String.class, (JsonDeserializer)new JsonHtmlXssDeserializer(String.class));
        this.registerModule((Module)module);
    }

    class JsonHtmlXssDeserializer
    extends JsonDeserializer<String> {
        public JsonHtmlXssDeserializer(Class<String> string) {
        }

        public Class<String> handledType() {
            return String.class;
        }

        public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String value = jsonParser.getValueAsString();
            return XssHttpServletRequestWrapper.convent(value);
        }
    }

    class JsonHtmlXssSerializer
    extends JsonSerializer<String> {
        public JsonHtmlXssSerializer(Class<String> string) {
        }

        public Class<String> handledType() {
            return String.class;
        }

        public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (value != null) {
                String encodedValue = XssHttpServletRequestWrapper.convent(value.toString());
                jsonGenerator.writeString(encodedValue);
            }
        }
    }
}

