/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.xss;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private static final Whitelist whitelist = Whitelist.none();
    private static final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
    private final boolean json;

    public XssHttpServletRequestWrapper(HttpServletRequest request, boolean json) {
        super(request);
        this.json = json;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return XssHttpServletRequestWrapper.convent(value);
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        return XssHttpServletRequestWrapper.convent(value);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = XssHttpServletRequestWrapper.convent(values[i]);
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.json) {
            return super.getInputStream();
        }
        String str = this.getRequestBody((InputStream)super.getInputStream());
        str = XssHttpServletRequestWrapper.convent(str);
        final ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }
        };
    }

    private String getRequestBody(InputStream stream) {
        String line = "";
        StringBuilder body = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        try {
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
        }
        catch (IOException e) {
            logger.warn("getRequestBody", (Throwable)e);
        }
        return body.toString();
    }

    public static String convent(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return str;
        }
        String s = str;
        try {
            s = Jsoup.clean((String)s, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
            s = XssHttpServletRequestWrapper.sqlConvent(s);
            if (s.contains("alert(")) {
                s = s.replace("alert(", "forbid");
            }
        }
        catch (Exception e) {
            logger.warn("convent", (Throwable)e);
        }
        return s;
    }

    private static String sqlConvent(String str) {
        String value = str;
        String[] values = value.split(" ");
        String badStr = "'|and|exec|execute|insert|select|delete|update|count|drop|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|-|+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|chr|mid|master|truncate|char|declare|or|;|-|--|,|like|//|/|%|#";
        String[] badStrs = badStr.split("\\|");
        for (int i = 0; i < badStrs.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                if (!values[j].equalsIgnoreCase(badStrs[i])) continue;
                values[j] = "forbid";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i == values.length - 1) {
                sb.append(values[i]);
                continue;
            }
            sb.append(values[i] + " ");
        }
        value = sb.toString();
        return value;
    }
}

