/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.filter.xss;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private static final Whitelist whitelist = Whitelist.none();
    private static final String badStr = "'|exec|execute|insert|select|delete|update|count|drop|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|-|+|,|like'|create|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|order|by|or|--|like|//|/|#";
    private static final List<String> badStrs = Arrays.asList("'|exec|execute|insert|select|delete|update|count|drop|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|-|+|,|like'|create|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|order|by|or|--|like|//|/|#".split("\\|"));
    private static final List<String> okStrs = new LinkedList<String>();
    private static final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
    private final boolean xssSample;
    private final boolean json;
    private final boolean isUpload;
    private static final String WINDOW_EVENT_REGEX = "prompt|onafterprint|onbeforeprint|onbeforeonload|onblur|onerror|onfocus|onhashchange|onload|onmessage|onoffline|ononline|onpagehide|onpageshow|onpopstate|onredo|onresize|onstorage|onundo|onunload";
    private static final String FORM_EVENT_REGEX = "onblur|onchange|oncontextmenu|onfocus|onformchange|onforminput|oninput|oninvalid|onreset|onselect|onsubmit";
    private static final String KEYBOARD_EVENT_REGEX = "onkeydown|onkeypress|onkeyup";
    private static final String MOUSE_EVENT_REGEX = "onclick|ondblclick|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onmousewheel|onscroll";
    private static final String MEDIA_EVENT_REGEX = "onabort|oncanplay|oncanplaythrough|ondurationchange|onemptied|onended|onerror|onloadeddata|onloadedmetadata|onloadstart|onpause|onplay|onplaying|onprogress|onratechange|onreadystatechange|onseeked|onseeking|onstalled|onsuspend|ontimeupdate|onvolumechange|onwaiting";
    private static final String OTHER_EVENT_REGEX = "onshow|ontoggle|window|having|location|alert|eval|Content-Type:|Content-Transfer-Encoding:|function";
    private static final String SQL_COMMENT_PATTERN = "(['\"]?.*(\\bor\\b|\\bunion\\b|\\/\\*))";
    private static final String SQL_SYNTAX_PATTERN = "(insert|delete|update|select|create|drop|truncate|grant|alter|deny|revoke|call|execute|exec|declare|show|rename|set)\\s+.*(into|from|set|where|table|database|view|index|on|cursor|procedure|trigger|for|password|union|and|or)|(select\\s*\\*\\s*from\\s+)";
    private static final Pattern p_window_event = Pattern.compile("prompt|onafterprint|onbeforeprint|onbeforeonload|onblur|onerror|onfocus|onhashchange|onload|onmessage|onoffline|ononline|onpagehide|onpageshow|onpopstate|onredo|onresize|onstorage|onundo|onunload", 2);
    private static final Pattern p_form_event = Pattern.compile("onblur|onchange|oncontextmenu|onfocus|onformchange|onforminput|oninput|oninvalid|onreset|onselect|onsubmit", 2);
    private static final Pattern p_keyboard_event = Pattern.compile("onkeydown|onkeypress|onkeyup", 2);
    private static final Pattern p_mouse_event = Pattern.compile("onclick|ondblclick|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup|onmousewheel|onscroll", 2);
    private static final Pattern p_media_event = Pattern.compile("onabort|oncanplay|oncanplaythrough|ondurationchange|onemptied|onended|onerror|onloadeddata|onloadedmetadata|onloadstart|onpause|onplay|onplaying|onprogress|onratechange|onreadystatechange|onseeked|onseeking|onstalled|onsuspend|ontimeupdate|onvolumechange|onwaiting", 2);
    private static final Pattern p_other_event = Pattern.compile("onshow|ontoggle|window|having|location|alert|eval|Content-Type:|Content-Transfer-Encoding:|function", 2);
    private static final Pattern p_sql_event = Pattern.compile("(insert|delete|update|select|create|drop|truncate|grant|alter|deny|revoke|call|execute|exec|declare|show|rename|set)\\s+.*(into|from|set|where|table|database|view|index|on|cursor|procedure|trigger|for|password|union|and|or)|(select\\s*\\*\\s*from\\s+)", 2);
    private static final Pattern p_comment_event = Pattern.compile("(['\"]?.*(\\bor\\b|\\bunion\\b|\\/\\*))", 2);

    public XssHttpServletRequestWrapper(HttpServletRequest request, boolean json, boolean xssSample) throws IOException {
        super(request);
        this.json = json;
        this.xssSample = xssSample;
        this.isUpload = request.getHeader("content-type") != null && request.getHeader("content-type").contains("multipart");
    }

    private boolean isXssSample() {
        return this.xssSample;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return value;
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (StringUtils.hasText((String)value) && value.length() > 500) {
            return value;
        }
        if (this.isXssSample()) {
            return XssHttpServletRequestWrapper.convent(value);
        }
        boolean res = this.checkParameter(name, value, Collections.emptyList(), Collections.emptyList());
        if (res) {
            throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                if (this.isXssSample()) {
                    escapseValues[i] = XssHttpServletRequestWrapper.convent(values[i]);
                    continue;
                }
                boolean res = this.checkParameter(name, values[i], Collections.emptyList(), Collections.emptyList());
                if (res) {
                    throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                }
                escapseValues[i] = values[i];
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isUpload) {
            return super.getInputStream();
        }
        if (!this.json) {
            return super.getInputStream();
        }
        String str = this.getRequestBody((InputStream)super.getInputStream());
        boolean res = this.checkBody(str, Collections.emptyList(), Collections.emptyList());
        if (res) {
            throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }
        };
    }

    public boolean checkParameter(String submitName, String value, Collection<String> excParams, Collection<String> excValues) {
        if (StringUtils.isEmpty((Object)value)) {
            return false;
        }
        if (value.length() > 500) {
            return false;
        }
        if ("access_token".equals(submitName) || "token".equals(submitName) || "rst".equals(submitName) || "st".equals(submitName)) {
            return false;
        }
        if (excParams.contains(submitName)) {
            return false;
        }
        boolean isValid = XssHttpServletRequestWrapper.hasHtml(value);
        if (isValid) {
            return true;
        }
        isValid = XssHttpServletRequestWrapper.sqlXss(value);
        return isValid;
    }

    public boolean checkBody(String body, Collection<String> excParams, Collection<String> excValues) {
        try {
            if (!StringUtils.hasText((String)body)) {
                return false;
            }
            Object obj = null;
            try {
                obj = JSON.parse((String)body);
            }
            catch (Exception e) {
                return XssHttpServletRequestWrapper.checkObject(body, excParams, excValues);
            }
            return XssHttpServletRequestWrapper.checkObject(obj, excParams, excValues);
        }
        catch (Exception e) {
            logger.warn("checkBody: " + e);
            return false;
        }
    }

    public static boolean checkObject(Object obj, Collection<String> excParams, Collection<String> excValues) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                boolean isValid;
                if (excParams.contains(entry.getKey()) || !(isValid = XssHttpServletRequestWrapper.checkObject(entry.getValue(), excParams, excValues))) continue;
                return true;
            }
        } else if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            for (int i = 0; i < array.size(); ++i) {
                Object o = array.get(i);
                boolean isValid = XssHttpServletRequestWrapper.checkObject(o, excParams, excValues);
                if (!isValid) continue;
                return true;
            }
        } else if (obj instanceof String) {
            if (obj.toString().length() > 500) {
                return false;
            }
            boolean isValid = XssHttpServletRequestWrapper.hasHtml(obj.toString());
            if (isValid) {
                return true;
            }
            isValid = XssHttpServletRequestWrapper.sqlXss(obj.toString());
            if (isValid) {
                return true;
            }
        }
        return false;
    }

    private String getRequestBody(InputStream stream) {
        String line = "";
        StringBuilder body = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        try {
            while ((line = reader.readLine()) != null) {
                body.append(line);
            }
        }
        catch (IOException e) {
            logger.warn("getRequestBody", (Throwable)e);
        }
        return body.toString();
    }

    private static boolean sqlXss(String str) {
        if (str.length() > 500) {
            return false;
        }
        Matcher m_sql_event = p_sql_event.matcher(str);
        if (m_sql_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)SQL_SYNTAX_PATTERN);
            return true;
        }
        Matcher m_comment_event = p_comment_event.matcher(str);
        if (m_comment_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)SQL_COMMENT_PATTERN);
            return true;
        }
        return false;
    }

    private static boolean hasHtml(String htmlStr) {
        Matcher m_window_event = p_window_event.matcher(htmlStr);
        if (m_window_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)WINDOW_EVENT_REGEX);
            return true;
        }
        Matcher m_form_event = p_form_event.matcher(htmlStr);
        if (m_form_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)FORM_EVENT_REGEX);
            return true;
        }
        Matcher m_keyboard_event = p_keyboard_event.matcher(htmlStr);
        if (m_keyboard_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)KEYBOARD_EVENT_REGEX);
            return true;
        }
        Matcher m_mouse_event = p_mouse_event.matcher(htmlStr);
        if (m_mouse_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)MOUSE_EVENT_REGEX);
            return true;
        }
        Matcher m_media_event = p_media_event.matcher(htmlStr);
        if (m_media_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)MEDIA_EVENT_REGEX);
            return true;
        }
        Matcher m_other_event = p_other_event.matcher(htmlStr);
        if (m_other_event.find()) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)OTHER_EVENT_REGEX);
            return true;
        }
        if (htmlStr.contains("||")) {
            logger.warn("\u975e\u6cd5\u5b57\u7b26:{}", (Object)"||");
            return true;
        }
        return false;
    }

    public static String conventStrict(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return str;
        }
        String s = str;
        try {
            s = Jsoup.clean((String)s, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
            if (okStrs.contains(s)) {
                return s;
            }
        }
        catch (Exception e) {
            logger.warn("conventStrict", (Throwable)e);
        }
        String lows = s.toLowerCase();
        if (XssHttpServletRequestWrapper.hasHtml(lows)) {
            throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        if (XssHttpServletRequestWrapper.sqlXss(lows)) {
            throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        if (lows.contains("count(")) {
            throw new IllegalArgumentException("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        return s;
    }

    public static String convent(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return str;
        }
        if (str.length() > 500) {
            return str;
        }
        String s = str;
        try {
            s = Jsoup.clean((String)s, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
            s = XssHttpServletRequestWrapper.sqlConvent(s);
            if (s.contains("alert(")) {
                s = s.replace("alert(", "forbid");
            }
        }
        catch (Exception e) {
            logger.warn("convent", (Throwable)e);
        }
        return s;
    }

    private static String sqlConvent(String str) {
        if (okStrs.contains(str)) {
            return str;
        }
        try {
            String value = str;
            String[] values = value.split(" ", -1);
            for (int j = 0; j < values.length; ++j) {
                if (!badStrs.contains(values[j].toLowerCase())) continue;
                values[j] = "forbid";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    sb.append(values[i]);
                    continue;
                }
                sb.append(values[i] + " ");
            }
            value = sb.toString();
            return value;
        }
        catch (Exception e) {
            logger.warn("sqlConvent:", (Throwable)e);
            return str;
        }
    }

    static {
        okStrs.add("create");
        okStrs.add("insert");
        okStrs.add("select");
        okStrs.add("update");
        okStrs.add("delete");
        okStrs.add("like");
        okStrs.add("from");
        okStrs.add("or");
        okStrs.add("by");
        okStrs.add("and");
        okStrs.add("char");
        okStrs.add("where");
        okStrs.add("having");
        okStrs.add("exec");
        okStrs.add("master");
        okStrs.add("order");
        okStrs.add("orderBy");
    }
}

