/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.filter.xss;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.config.StaticCfgContext;
import cn.gtmap.gtc.starter.gcas.filter.xss.XssHttpServletRequestWrapper;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

public class XssFilter
extends OncePerRequestFilter {
    private final boolean enabled;
    private final Collection<String> urls;
    private final Collection<String> excludes;
    private final boolean json;
    private final boolean xssSample;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public XssFilter(String xss, boolean json, String exclude, boolean xssSample) {
        this.xssSample = xssSample;
        HashSet<String> us = new HashSet<String>();
        if (!StringUtils.isEmpty((Object)xss)) {
            us.addAll(StringUtils.commaDelimitedListToSet((String)xss));
        }
        if (!StringUtils.isEmpty((Object)StaticCfgContext.getXssPath())) {
            us.addAll(StringUtils.commaDelimitedListToSet((String)StaticCfgContext.getXssPath()));
        }
        this.enabled = !CollectionUtils.isEmpty(us);
        this.urls = us;
        this.json = json || StaticCfgContext.getXssJson() != null && StaticCfgContext.getXssJson() != false;
        this.excludes = StringUtils.commaDelimitedListToSet((String)exclude);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (request.getServletPath().endsWith("/env") || request.getServletPath().endsWith("/heapdump") || request.getServletPath().contains("..;") || request.getServletPath().endsWith("/logfile") || request.getServletPath().endsWith("/mappings") || request.getServletPath().endsWith("/actuator/") || request.getServletPath().endsWith("/shutdown") || request.getServletPath().endsWith("/beans") || request.getServletPath().endsWith("/actuator")) {
            String res = "# response_auth_error No permission";
            httpServletResponse.setContentType("text/plain;charset=utf-8");
            httpServletResponse.getWriter().write(res);
            return;
        }
        String method = request.getMethod();
        if (this.isExcludeMethod(method)) {
            if (this.enabled) {
                if ("application/xml".equalsIgnoreCase(request.getHeader("Content-Type"))) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
                    return;
                }
                String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
                if (ClientIpUtils.matchUrl(this.pathMatcher, this.excludes, lookupPath)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
                    return;
                }
                if (ClientIpUtils.matchUrl(this.pathMatcher, StaticCfgContext.getXssExcludes(), lookupPath)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
                    return;
                }
                if (ClientIpUtils.matchUrl(this.pathMatcher, this.urls, lookupPath)) {
                    filterChain.doFilter((ServletRequest)new XssHttpServletRequestWrapper(request, this.json, this.xssSample), (ServletResponse)httpServletResponse);
                    return;
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
        } else {
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("code", "1");
            err.put("meg", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f");
            httpServletResponse.getWriter().write(ObjectMapperUtils.toJson(err));
        }
    }

    private boolean isExcludeMethod(String method) {
        if ("GET".equalsIgnoreCase(method)) {
            return true;
        }
        if ("PUT".equalsIgnoreCase(method)) {
            return true;
        }
        if ("DELETE".equalsIgnoreCase(method)) {
            return true;
        }
        if ("POST".equalsIgnoreCase(method)) {
            return true;
        }
        if ("OPTION".equalsIgnoreCase(method)) {
            return true;
        }
        if ("PATCH".equalsIgnoreCase(method)) {
            return true;
        }
        if ("HEADER".equalsIgnoreCase(method)) {
            return true;
        }
        if ("TRANCE".equalsIgnoreCase(method)) {
            return true;
        }
        return "CONNECT".equalsIgnoreCase(method);
    }
}

