/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.filter.xss;

import cn.gtmap.gtc.starter.gcas.filter.xss.XssHttpServletRequestWrapper;
import cn.gtmap.gtc.starter.gcas.util.ClientIpUtils;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UrlPathHelper;

public class XssFilter
extends OncePerRequestFilter {
    private final Collection<String> urls;
    private final Collection<String> excludes;
    private final boolean json;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public XssFilter(String xss, boolean json, String exclude) {
        if (StringUtils.isEmpty((Object)xss)) {
            xss = "/**";
        }
        this.urls = StringUtils.commaDelimitedListToSet((String)xss);
        this.json = json;
        this.excludes = StringUtils.commaDelimitedListToSet((String)exclude);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (ClientIpUtils.matchUrl(this.pathMatcher, this.excludes, lookupPath)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
            return;
        }
        if (ClientIpUtils.matchUrl(this.pathMatcher, this.urls, lookupPath)) {
            filterChain.doFilter((ServletRequest)new XssHttpServletRequestWrapper(request, this.json), (ServletResponse)httpServletResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)httpServletResponse);
    }
}

