/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.config;

import cn.gtmap.gtc.starter.gcas.property.FeignTransferProperties;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GtFeignRequestInterceptor
implements RequestInterceptor {
    private final Log logger = LogFactory.getLog(GtFeignRequestInterceptor.class);
    private FeignTransferProperties transferProperties;

    public GtFeignRequestInterceptor(FeignTransferProperties transferProperties) {
        this.transferProperties = transferProperties;
    }

    public void apply(RequestTemplate template) {
        block4: {
            try {
                if (this.transferProperties.getQueries() != null && this.transferProperties.getQueries().length > 0) {
                    HttpServletRequest request;
                    Map parameterMap;
                    List<String> queries = Arrays.asList(this.transferProperties.getQueries());
                    ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (null != attributes && !CollectionUtils.isEmpty((Map)(parameterMap = (request = attributes.getRequest()).getParameterMap()))) {
                        queries.forEach(s -> template.query(s, (String[])parameterMap.get(s)));
                    }
                }
            }
            catch (Exception e2) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)"apply.query", (Throwable)e2);
            }
        }
    }
}

