/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.starter.gcas.annotation;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.starter.gcas.annotation.Firewalld;
import cn.gtmap.gtc.starter.gcas.filter.xss.XssHttpServletRequestWrapper;
import cn.gtmap.gtc.starter.gcas.filter.xss.XssObjectMapper;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

@Aspect
public class FirewalldAspect {
    static final Logger log = LoggerFactory.getLogger(FirewalldAspect.class);
    private static final XssObjectMapper xssObjectMapper = new XssObjectMapper();

    @Around(value="@within(firewalldActuator)")
    public Object doConvent(ProceedingJoinPoint joinPoint, Firewalld firewalldActuator) throws Throwable {
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Firewalld method = targetMethod.getDeclaredAnnotation(Firewalld.class);
        if (method != null) {
            if (method.filter()) {
                this.conventData(args);
            }
        } else if (firewalldActuator.filter()) {
            this.conventData(args);
        }
        return joinPoint.proceed(args);
    }

    private void conventData(Object[] args) {
        if (null != args) {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (null == o || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof Model || o instanceof ModelAndView || o instanceof Principal) continue;
                String className = o.getClass().getName();
                if ("java.lang.String".equals(className)) {
                    args[i] = XssHttpServletRequestWrapper.convent(o.toString());
                    continue;
                }
                if (className.contains("java.lang.") || className.contains("org.springframework")) continue;
                try {
                    String value = ObjectMapperUtils.toJson((Object)o);
                    args[i] = xssObjectMapper.readValue(value, o.getClass());
                    continue;
                }
                catch (Exception e) {
                    log.warn("FirewalldAspect", (Throwable)e);
                }
            }
        }
    }
}

