/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.message.service.impl;

import cn.gtmap.gtc.message.service.SmsService;
import cn.gtmap.gtc.msg.domain.dto.AliSmsDto;
import cn.gtmap.gtc.msg.domain.enums.SmsType;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.AlibabaAliqinFcSmsNumSendRequest;
import com.taobao.api.response.AlibabaAliqinFcSmsNumSendResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final Logger logger = LoggerFactory.getLogger(SmsServiceImpl.class);
    private static final String ALI_APP_URL = "http://gw.api.taobao.com/router/rest";

    public void aliSmsSend(AliSmsDto msg) throws ApiException {
        if (SmsType.ALI_PLATFORM.getName().equals(msg.getPlatform())) {
            this.sendAliDyMsg(msg);
        } else {
            this.sendAliAppMsg(msg);
        }
    }

    public void sendAliAppMsg(AliSmsDto msg) throws ApiException {
        DefaultTaobaoClient client = new DefaultTaobaoClient(ALI_APP_URL, msg.getAppKey(), msg.getAppSecret());
        AlibabaAliqinFcSmsNumSendRequest req = new AlibabaAliqinFcSmsNumSendRequest();
        req.setExtend(msg.getExtend());
        req.setSmsType("normal");
        req.setSmsFreeSignName(msg.getSignName());
        req.setSmsParamString(msg.getParamString());
        req.setRecNum(msg.getRecNum());
        req.setSmsTemplateCode(msg.getTemplateCode());
        AlibabaAliqinFcSmsNumSendResponse rsp = (AlibabaAliqinFcSmsNumSendResponse)client.execute((TaobaoRequest)req);
        if (rsp.getResult() == null) {
            throw new ApiException(rsp.getSubMsg());
        }
        if (!rsp.getResult().getSuccess().booleanValue()) {
            throw new ApiException(rsp.getResult().getMsg());
        }
    }

    public void sendAliDyMsg(AliSmsDto msg) {
        DefaultProfile profile = DefaultProfile.getProfile((String)"default", (String)msg.getAppKey(), (String)msg.getAppSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("RegionId", "default");
        request.putQueryParameter("PhoneNumbers", msg.getRecNum());
        request.putQueryParameter("SignName", msg.getSignName());
        request.putQueryParameter("TemplateCode", msg.getTemplateCode());
        request.putQueryParameter("TemplateParam", msg.getParamString());
        try {
            CommonResponse response = client.getCommonResponse(request);
            if (response != null && response.getHttpStatus() == HttpStatus.OK.value()) {
                logger.info("send success for {}:{}", (Object)msg.getRecNum(), (Object)response.getData());
            }
        }
        catch (ClientException e) {
            logger.error("sendMsg", (Throwable)e);
        }
    }
}

