package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.resource.domain.resource.metadata.Nodelist;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import org.apache.commons.lang.StringUtils;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class TreeBuilder {

    List<Nodelist> nodes = new ArrayList<>();

    public String buildTree(List<Nodelist> nodes) {

        TreeBuilder treeBuilder = new TreeBuilder(nodes);

        return treeBuilder.buildJSONTree();
    }

    public TreeBuilder() {
    }

    public TreeBuilder(List<Nodelist> nodes) {
        super();
        this.nodes = nodes;
    }

    // 构建JSON树形结构
    public String buildJSONTree() {
        List<Nodelist> nodeTree = buildTree();
        return JSON.toJSONString(nodeTree);
    }

    // 构建树形结构
    public List<Nodelist> buildTree() {
        List<Nodelist> treeNodes = new ArrayList<>();
        List<Nodelist> rootNodes = getRootNodes();
        for (Nodelist rootNode : rootNodes) {
            buildChildNodes(rootNode);
            treeNodes.add(rootNode);
        }
        return treeNodes;
    }

    // 递归子节点
    public void buildChildNodes(Nodelist Nodelist) {
        List<Nodelist> children = getChildNodes(Nodelist);
        if (!children.isEmpty()) {
            for (Nodelist child : children) {
                buildChildNodes(child);
            }
            Nodelist.setChildren(children);
        }
    }

    // 获取父节点下所有的子节点
    public List<Nodelist> getChildNodes(Nodelist pnode) {
        List<Nodelist> childNodes = new ArrayList<>();
        for (Nodelist n : nodes) {
            if (pnode.getId().equals(n.getPid())) {
                childNodes.add(n);
            }
        }
        return childNodes;
    }

    // 判断是否为根节点
    public boolean rootNode(Nodelist Nodelist) {
        boolean isRootNode = true;
        for (Nodelist n : nodes) {
            if (n.getId().equals(Nodelist.getPid())) {
                isRootNode = false;
                break;
            }
        }
        return isRootNode;
    }

    // 获取集合中所有的根节点
    public List<Nodelist> getRootNodes() {
        List<Nodelist> rootNodes = new ArrayList<>();
        for (Nodelist n : nodes) {
            if (rootNode(n)) {
                rootNodes.add(n);
            }
        }
        return rootNodes;
    }

}
