package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.resource.domain.resource.dto.es.DataResourceIdxDTO;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-4-8
 * @description
 */

public class ResourceLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLogUtil.class);
    public static final FastDateFormat SDF = FastDateFormat.getInstance("yyyy-MM");
    public static final String ALL_INDEX = "data-resource-*";

    private static final String INDEX = "data-resource";

    public static String getNowIndex() {
        String str = SDF.format(new Date());
        return INDEX.concat("-").concat(str);
    }


    public static Map<String, Object> getDatas(DataResourceIdxDTO dto) {
        Map<String,Object> map = new HashMap<>();
        Field[] fields = dto.getClass().getDeclaredFields();
        for(Field field:fields){
            field.setAccessible(true);
            try {
                if (field.get(dto) != null){
                    map.put(field.getName(), field.get(dto));
                }
            } catch (IllegalAccessException e) {
                logger.warn("getDatas", e);
            }
        }
        return map;
    }

}
