package cn.gtmap.gtc.resource.domain.server;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.util.Date;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2019/12/9 10:43
 * 3
 */
@Entity
@Table(name = "gt_server_status")
public class ServerStatus {

    private Date createAt;
    private Date updateAt;

    /**
     * 服务id
     */
    @Id
    private String serverId;
    /**
     * 服务类型
     * 其他：0
     * 服务器主机资源监控：1
     * 微服务监控：2
     * 地图服务监控：3
     */
    private String serverType;

    /**
     * 服务内容
     */
    private String serverContent;

    /**
     * 服务标题
     */
    private String serverTitle;

    /**
     * 服务状态
     * 其他：0
     * 正常：1
     * 异常：2
     * 警告：3
     * 停用：4
     */
    private String serverStatus;

    /**
     * 是否通知
     * 是：1
     * 否：0
     */
    private String noticed;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否有历史记录
     */
    private boolean hasHis;

    @Temporal(TemporalType.TIMESTAMP)
    @CreationTimestamp
    @Column(updatable = false)
    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @UpdateTimestamp
    public Date getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
    }

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerType() {
        return serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerContent() {
        return serverContent;
    }

    public void setServerContent(String serverContent) {
        this.serverContent = serverContent;
    }

    public String getServerTitle() {
        return serverTitle;
    }

    public void setServerTitle(String serverTitle) {
        this.serverTitle = serverTitle;
    }

    public String getServerStatus() {
        return serverStatus;
    }

    public void setServerStatus(String serverStatus) {
        this.serverStatus = serverStatus;
    }

    public String getNoticed() {
        return noticed;
    }

    public void setNoticed(String noticed) {
        this.noticed = noticed;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isHasHis() {
        return hasHis;
    }

    public void setHasHis(boolean hasHis) {
        this.hasHis = hasHis;
    }
}
