package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.*;
import java.util.Date;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2020/3/23 17:12
 * 3
 */
@Entity
@Table(name = "gt_res_access")
public class ResAccess {

    //资源id
    @Id
    @Column(name = "res_id")
    private String id;

    //资源名称
    @Column(name = "res_title")
    private String resTitle;

    //资源受限ip
    @Column(name = "ip_str")
    private String ipStr;

    private Date createAt;
    private Date updateAt;
    protected boolean enabled = true;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResTitle() {
        return resTitle;
    }

    public void setResTitle(String resTitle) {
        this.resTitle = resTitle;
    }

    public String getIpStr() {
        return ipStr;
    }

    public void setIpStr(String ipStr) {
        this.ipStr = ipStr;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @CreationTimestamp
    @Column(updatable = false)
    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public ResAccess setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @UpdateTimestamp
    public Date getUpdateAt() {
        return updateAt;
    }

    public ResAccess setUpdateAt(Date updateAt) {
        this.updateAt = updateAt;
        return this;
    }
}
