package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.ID;
import cn.gtmap.gtc.resource.domain.core.Title;
import cn.gtmap.gtc.resource.domain.core.Type;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * .MIMEType
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2017/11/10 9:41
 */
@Entity
@Table(name = "gt_mime_type", indexes = {
        @Index(columnList = "extension", name = "mt_ext_idx")
})
public class MIMEType extends ID implements Type, Title {

    /**
     * 扩展名或者类型简述
     */
    private String extension;
    /**
     * 类型描述
     */
    private String title;
    /**
     * mime type 类型
     */
    private String type;

    @Column(unique = true)
    public String getExtension() {
        return extension;
    }

    public MIMEType setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    @Override
    public String getTitle() {
        return title;
    }

    public MIMEType setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public String getType() {
        return type;
    }

    public MIMEType setType(String type) {
        this.type = type;
        return this;
    }
}
