package cn.gtmap.gtc.resource.domain.resource.metadata;

import cn.gtmap.gtc.resource.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.*;
import java.util.List;

/**
 * @author zgl
 * @date 2018-03-16
 */
@Entity
@Table(name = "gt_dict",indexes = {
        @Index(columnList = "dict_key", name = "dict_key_idx"),
        @Index(columnList = "type", name = "dict_type_idx")
})
public class Dict extends BaseEntity {
    /**
     * 字典类型 枚举
     */
    private int type;

    /**
     * 字典key唯一标识
     */
    @Column(unique = true)
    private String dict_key;
    /**
     * 字典标题
     */
    private String title;
    /**
     * 字典vaule存储关联其他的内容
     */
    private String value;
    /**
     * 字典描述
     */
    private String description;
    /**
     * 字典权重，排序
     */
    private int weight;
    /**
     * 字典层级父级
     */
    private Dict parent;
    /**
     * 字典层级子级
     */
    private List<Dict> children;

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDict_key() {
        return dict_key;
    }

    public void setDict_key(String dict_key) {
        this.dict_key = dict_key;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Lob
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @JsonIgnore
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    public Dict getParent() {
        return parent;
    }

    public void setParent(Dict parent) {
        this.parent = parent;
    }

    @OneToMany(mappedBy = "parent", cascade = CascadeType.ALL)
    @OrderBy("weight asc")
    public List<Dict> getChildren() {
        return children;
    }

    public void setChildren(List<Dict> children) {
        this.children = children;
    }

}
